' ******************************************************************************
' * Title         : Exp.14.bas                                                 *
' * Target Board  : Mini-Phoenix - REV 1.00                                    *
' * Target MCU    : ATMega32A                                                  *
' * Author        : Walid Balid                                                *
' * IDE           : BASCOM AVR 2.0.7.3                                         *
' * Peripherals   : 16 x 2 LCD                                                 *
' * Description   : 4 bit LCD Mode                                             *
' ******************************************************************************
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'-----------------------[Definitions]
$regfile = "m32def.dat"
$crystal = 8000000
'-----------------------
'-----------------------[LCD Configurations]
Config Lcdpin = Pin , Db4 = Portc.2 , Db5 = Portc.3 , Db6 = Portc.4 , Db7 = Portc.5 , E = Portd.3 , Rs = Portd.4
Config Lcd = 16 * 2
'-----------------------
'-----------------------[Variables]
Dim I As Byte
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'--->[Main Program]
Do
   Cls
   Upperline : Lcd "~~Hello World!~~" : Wait 1
   Lowerline : Lcd "(LCD 4-bit Mode)" : Wait 1

   Gosub Shift2right : Gosub Shift2left

   Locate 1 , 8 : Lcd ":" : Wait 1
   Locate 2 , 1 : Lcd ">" : Wait 1

   Shiftcursor Right : Wait 1 : Shiftcursor Left

   Cursor Off Noblink : Wait 1 : Cursor On Blink

   Display Off : Wait 1 : Display On

   Home Upper : Wait 1 : Cls

   Deflcdchar 0 , 32 , 32 , 10 , 21 , 17 , 10 , 4 , 32
   Deflcdchar 1 , 4 , 10 , 17 , 10 , 10 , 17 , 10 , 4
   Locate 1 , 9 : Lcd Chr(0) : Wait 1
   Locate 2 , 9 : Lcd Chr(1) : Wait 1
Loop
End
'---<[End Main]
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'--->[Shift LCD Char to Right]
Shift2right:
   For I = 1 To 8
      Shiftlcd Right : Waitms 500
   Next I
Return
'-----------------------
'--->[Shift LCD Char to Left]
Shift2left:
   For I = 1 To 8
      Shiftlcd Left : Waitms 500
   Next I
Return
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~